#!/bin/sh

MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG=""
MASTER_PAGE_DATA_NETWORK_CONF_RESULT_OK=0
MASTER_PAGE_DATA_NETWORK_CONF_RESULT_ERROR=1

MASTER_PAGE_DATA_NETWORK_CONF_RESULT_CODE=${MASTER_PAGE_DATA_NETWORK_CONF_RESULT_ERROR}
MASTER_PAGE_DATA_NETWORK_CONF_RESULT_ROLLING=0

MASTER_PAGE_DATA_NETWORK_USER_INPUT_IP=""
MASTER_PAGE_DATA_NETWORK_USER_INPUT_NETMASK=""
MASTER_PAGE_DATA_NETWORK_USER_INPUT_GATEWAY=""
MASTER_PAGE_DATA_NETWORK_USER_INPUT_DNS=""
MASTER_PAGE_DATA_NETWORK_USER_INPUT_DNS2=""
    
MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6=""
MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_PREFIX_LENGTH=""
MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_GATEWAY=""
MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_DNS=""
MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_DNS2=""

master_page_data_network_conf() {
    #dprint 0 "debug" "Enter master_page_ms_network_conf ${conf_data_ip} ${conf_data_netmask} ${conf_data_gateway} ${conf_data_dns} ${conf_data_dns2} ${conf_data_ipv6} ${conf_data_ipv6_prefix_length} ${conf_data_ipv6_gateway} ${conf_data_ipv6_dns} ${conf_data_ipv6_dns2}"

    # assign default value
    [ -z "${RT_DATA_IP}" ]      && RT_DATA_IP="${conf_data_ip}"
    [ -z "${RT_DATA_NETMASK}" ] && RT_DATA_NETMASK="${conf_data_netmask}"
    [ -z "${RT_DATA_GATEWAY}" ] && RT_DATA_GATEWAY="${conf_data_gateway}"
    [ -z "${RT_DATA_DNS}" ]     && RT_DATA_DNS="${conf_data_dns}"
    [ -z "${RT_DATA_DNS2}" ]     && RT_DATA_DNS2="${conf_data_dns2}"

    [ -z "${RT_DATA_IPV6}" ]      && RT_DATA_IPV6="${conf_data_ipv6}"
    [ -z "${RT_DATA_IPV6_PREFIX_LENGTH}" ] && RT_DATA_IPV6_PREFIX_LENGTH="${conf_data_ipv6_prefix_length}"
    [ -z "${RT_DATA_IPV6_GATEWAY}" ] && RT_DATA_IPV6_GATEWAY="${conf_data_ipv6_gateway}"
    [ -z "${RT_DATA_IPV6_DNS}" ]     && RT_DATA_IPV6_DNS="${conf_data_ipv6_dns}"
    [ -z "${RT_DATA_IPV6_DNS2}" ]     && RT_DATA_IPV6_DNS2="${conf_data_ipv6_dns2}"

	tp_network_conf \
		"${MASTER_PAGE_DATA_NETWORK_CONF_TITLE}" \
		"${MASTER_PAGE_DATA_NETWORK_CONF_TEXT}" \
		"${MASTER_PAGE_DATA_NETWORK_CONF_LABEL_OK}" \
		"${MASTER_PAGE_DATA_NETWORK_CONF_LABEL_CANCEL}" \
        "${MASTER_PAGE_DATA_NETWORK_USER_INPUT_IP:-$RT_DATA_IP}" \
        "${MASTER_PAGE_DATA_NETWORK_USER_INPUT_NETMASK:-$RT_DATA_NETMASK}" \
        "${MASTER_PAGE_DATA_NETWORK_USER_INPUT_GATEWAY:-$RT_DATA_GATEWAY}" \
        "${MASTER_PAGE_DATA_NETWORK_USER_INPUT_DNS:-$RT_DATA_DNS}" \
        "${MASTER_PAGE_DATA_NETWORK_USER_INPUT_DNS2:-$RT_DATA_DNS2}" \
        "${MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6:-$RT_DATA_IPV6}" \
        "${MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_PREFIX_LENGTH:-$RT_DATA_IPV6_PREFIX_LENGTH}" \
        "${MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_GATEWAY:-$RT_DATA_IPV6_GATEWAY}" \
        "${MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_DNS:-$RT_DATA_IPV6_DNS}" \
        "${MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_DNS2:-$RT_DATA_IPV6_DNS2}"

    #debug_print "${0}" "${LINENO}" "TP_NETWORK_CONF_RESULT_CODE: ${TP_NETWORK_CONF_RESULT_CODE}"
    case "${TP_NETWORK_CONF_RESULT_CODE}" in
    
        "${TP_NETWORK_CONF_RESULT_ERROR}")
            MASTER_PAGE_DATA_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_DATA_NETWORK_CONF_RESULT_ERROR
            MASTER_PAGE_DATA_NETWORK_CONF_RESULT_ROLLING=0
            MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_RESULT_MSG}"

            RT_DATA_IP="${TP_NETWORK_CONF_RESULT_IP}"
            RT_DATA_NETMASK="${TP_NETWORK_CONF_RESULT_NETMASK}"
            RT_DATA_GATEWAY="${TP_NETWORK_CONF_RESULT_GATEWAY}"
            RT_DATA_DNS="${TP_NETWORK_CONF_RESULT_DNS}"
            RT_DATA_DNS2="${TP_NETWORK_CONF_RESULT_DNS2}"
            RT_DATA_IPV6="${TP_NETWORK_CONF_RESULT_IPV6}"
            RT_DATA_IPV6_PREFIX_LENGTH="${TP_NETWORK_CONF_RESULT_IPV6_PREFIX_LENGTH}"
            RT_DATA_IPV6_GATEWAY="${TP_NETWORK_CONF_RESULT_IPV6_GATEWAY}"
            RT_DATA_IPV6_DNS="${TP_NETWORK_CONF_RESULT_IPV6_DNS}"
            RT_DATA_IPV6_DNS2="${TP_NETWORK_CONF_RESULT_IPV6_DNS2}"

            return
            ;;
        
        "${TP_NETWORK_CONF_RESULT_CANCEL}")
            MASTER_PAGE_DATA_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_DATA_NETWORK_CONF_RESULT_OK
            MASTER_PAGE_DATA_NETWORK_CONF_RESULT_ROLLING=-1
            MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG=""
            
            MASTER_PAGE_DATA_NETWORK_USER_INPUT_IP=""
            MASTER_PAGE_DATA_NETWORK_USER_INPUT_NETMASK=""
            MASTER_PAGE_DATA_NETWORK_USER_INPUT_GATEWAY=""
            MASTER_PAGE_DATA_NETWORK_USER_INPUT_DNS=""
            MASTER_PAGE_DATA_NETWORK_USER_INPUT_DNS2=""
            MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6=""
            MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_PREFIX_LENGTH=""
            MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_GATEWAY=""
            MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_DNS=""
            MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_DNS2=""

            RT_DATA_IP=""
            RT_DATA_NETMASK=""
            RT_DATA_GATEWAY=""
            RT_DATA_DNS=""
            RT_DATA_DNS2=""
            RT_DATA_IPV6=""
            RT_DATA_IPV6_PREFIX_LENGTH=""
            RT_DATA_IPV6_GATEWAY=""
            RT_DATA_IPV6_DNS=""
            RT_DATA_IPV6_DNS2=""
            
            return
            ;;
            
        "${TP_NETWORK_CONF_RESULT_OK}" )
            RT_DATA_IP=""
            RT_DATA_NETMASK=""
            RT_DATA_GATEWAY=""
            RT_DATA_DNS=""
            RT_DATA_DNS2=""
            RT_DATA_IPV6=""
            RT_DATA_IPV6_PREFIX_LENGTH=""
            RT_DATA_IPV6_GATEWAY=""
            RT_DATA_IPV6_DNS=""
            RT_DATA_IPV6_DNS2=""
            ;;
        
        *)
            MASTER_PAGE_DATA_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_DATA_NETWORK_CONF_RESULT_ERROR
            MASTER_PAGE_DATA_NETWORK_CONF_RESULT_ROLLING=0
            MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${MASTER_PAGE_DATA_NETWORK_CONF_ERROR_UNKNOWN}"

            RT_DATA_IP=""
            RT_DATA_NETMASK=""
            RT_DATA_GATEWAY=""
            RT_DATA_DNS=""
            RT_DATA_DNS2=""
            RT_DATA_IPV6=""
            RT_DATA_IPV6_PREFIX_LENGTH=""
            RT_DATA_IPV6_GATEWAY=""
            RT_DATA_IPV6_DNS=""
            RT_DATA_IPV6_DNS2=""
            return
            ;;
    esac

    # apply and error handling

#	if [ "${TP_NETWORK_CONF_RESULT_DNS2}" == "..." ]; then
#        TP_NETWORK_CONF_RESULT_DNS2=""
#    fi

	dialog \
		--title     "Message" \
		--backtitle "${CONS_BACK_TITLE}" \
		--msgbox    "${TP_NETWORK_CONF_MSG_WAIT}" \
		            "${CONS_BOX_HEIGHT}" \
					"${CONS_BOX_ERROR_WIDTH}"

    local hostname="" # Because there is no hostname input field in Text UI. Assign it to empty string for later module to keep hostname unchanged
    local RET_MSG=`/opt/TrendMicro/Pixiebob/textUI/network_settings_hostname_ip.sh "set" "${hostname}" \
            "${TP_NETWORK_CONF_RESULT_IP}" "${TP_NETWORK_CONF_RESULT_NETMASK}" \
            "${TP_NETWORK_CONF_RESULT_GATEWAY}" "${TP_NETWORK_CONF_RESULT_DNS}" \
            "${TP_NETWORK_CONF_RESULT_DNS2}" \
            "${TP_NETWORK_CONF_RESULT_IPV6}" "${TP_NETWORK_CONF_RESULT_IPV6_PREFIX_LENGTH}" \
            "${TP_NETWORK_CONF_RESULT_IPV6_GATEWAY}" "${TP_NETWORK_CONF_RESULT_IPV6_DNS}" \
            "${TP_NETWORK_CONF_RESULT_IPV6_DNS2}" "from_text_ui" "eth1"  2>/dev/null`

    echo "RESULT: $RET_MSG"
    local ERR_CODE=`echo "$RET_MSG" | grep err_code | sed -e 's/^\"err_code\"\ :\ \"//g' | sed -e 's/\",$//g'`
    #dprint 0 "debug" "ERR_CODE = $ERR_CODE"

   # /opt/TrendMicro/DTAS/ManagementServer/bin/lock /opt/TrendMicro/locks/system_network_setting.lock R WAIT echo

    if [ "$ERR_CODE" == "" ]; then
        # apply successfully
        CONS_BACK_TITLE="Trend Micro Deep Discovert Director $(cat /opt/TrendMicro/Pixiebob/version.txt)"
        IPV4_ADDR=${TP_NETWORK_CONF_RESULT_IP}
        IPV6_ADDR=${TP_NETWORK_CONF_RESULT_IPV6}
        [ "${IPV4_ADDR}" = "" ] && IPV4_ADDR="-"
        [ "${IPV6_ADDR}" = "" ] && IPV6_ADDR="-"
        CONS_IP_ADDR="(IPv4: ${IPV4_ADDR} | IPv6: ${IPV6_ADDR})"
        CONS_IP_ADDR_V4="IPv4: ${IPV4_ADDR}"
        CONS_IP_ADDR_V6="IPv6: ${IPV6_ADDR}"
        conf_data_ip=${TP_NETWORK_CONF_RESULT_IP}
        conf_data_netmask=${TP_NETWORK_CONF_RESULT_NETMASK}
        conf_data_gateway=${TP_NETWORK_CONF_RESULT_GATEWAY}
        conf_data_dns=${TP_NETWORK_CONF_RESULT_DNS}
        conf_data_dns2=${TP_NETWORK_CONF_RESULT_DNS2}
        conf_data_ipv6=${TP_NETWORK_CONF_RESULT_IPV6}
        conf_data_ipv6_prefix_length=${TP_NETWORK_CONF_RESULT_IPV6_PREFIX_LENGTH}
        conf_data_ipv6_gateway=${TP_NETWORK_CONF_RESULT_IPV6_GATEWAY}
        conf_data_ipv6_dns=${TP_NETWORK_CONF_RESULT_IPV6_DNS}
        conf_data_ipv6_dns2=${TP_NETWORK_CONF_RESULT_IPV6_DNS2}
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IP=""
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_NETMASK=""
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_GATEWAY=""
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_DNS=""
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_DNS2=""
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6=""
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_PREFIX_LENGTH=""
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_GATEWAY=""
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_DNS=""
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_DNS2=""

        MASTER_PAGE_DATA_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_DATA_NETWORK_CONF_RESULT_OK
        MASTER_PAGE_DATA_NETWORK_CONF_RESULT_ROLLING=1
        MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG=""
    else
        # invalid input or system locked
        local ERR_MSG=`echo "$RET_MSG" | grep err_message | sed -e 's/^\"err_message\"\ :\ \"//g' | sed -e 's/\"$//g'`
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IP=${TP_NETWORK_CONF_RESULT_IP}
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_NETMASK=${TP_NETWORK_CONF_RESULT_NETMASK}
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_GATEWAY=${TP_NETWORK_CONF_RESULT_GATEWAY}
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_DNS=${TP_NETWORK_CONF_RESULT_DNS}
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_DNS2=${TP_NETWORK_CONF_RESULT_DNS2}
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6=${TP_NETWORK_CONF_RESULT_IPV6}
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_PREFIX_LENGTH=${TP_NETWORK_CONF_RESULT_IPV6_PREFIX_LENGTH}
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_GATEWAY=${TP_NETWORK_CONF_RESULT_IPV6_GATEWAY}
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_DNS=${TP_NETWORK_CONF_RESULT_IPV6_DNS}
        MASTER_PAGE_DATA_NETWORK_USER_INPUT_IPV6_DNS2=${TP_NETWORK_CONF_RESULT_IPV6_DNS2}

        MASTER_PAGE_DATA_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_DATA_NETWORK_CONF_RESULT_ERROR
        MASTER_PAGE_DATA_NETWORK_CONF_RESULT_ROLLING=0

        #dprint 0 "debug" "ERR_CODE = $ERR_CODE"

        case "${ERR_CODE}" in
        
            "2")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IP}"
                return
                ;;
            "3")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_NETMASK}"
                return
                ;;
            "4")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_GATEWAY}"
                return
                ;;
            "5")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_DNS}"
                return
                ;;
            "6")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_DNS2}"
                return
                ;;
            "7")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_SYSTEM_LOCKED}"
                return
                ;;
            "8")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${ERR_MSG}"
                return
                ;;
            "9")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_EMPTY_IP_AND_IPV6}"
                return
                ;;
            "10")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6}"
                return
                ;;
            "11")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_PREFIX_LENGTH}"
                return
                ;;
            "12")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_GATEWAY}"
                return
                ;;
            "13")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_DNS}"
                return
                ;;
            "14")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_DNS2}"
                return
                ;;
            "17")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_IPV4_ADDRESS_CONFLICT} ${TP_NETWORK_CONF_RESULT_IP}."
                return
                ;;
            "18")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_IPV6_ADDRESS_CONFLICT} ${TP_NETWORK_CONF_RESULT_IPV6}."
                return
                ;;
            "21")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV4_4_VIP}"
                return
                ;;
            "22")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_4_VIP}"
                return
                ;;
            "23")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_NULL}"
                return
                ;;
            "24")
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_CHANGE}"
                return
                ;;
            *)
                MASTER_PAGE_DATA_NETWORK_CONF_RESULT_MSG="${MASTER_PAGE_DATA_NETWORK_CONF_ERROR_UNKNOWN}"
                return
                ;;
        esac        
    fi
}
